# This extensions allows the intergration of pdScript into SketchUp
# Additional info about pdScript at www.be-precision.com/products/pdScript/
#-----------------------------------------------------------------------------
require('sketchup.rb')
require('extensions.rb')
require('pdScript/langLoad.rb')

module PdScript
  plugdir = Sketchup.find_support_file('Plugins')
  langcode = Sketchup.get_locale.split('-')[0]
  @@extdir = "pdScript"
  langdir  = "lang"
  langpath = File.join(plugdir,@@extdir,langdir,"pdScript_menu.#{langcode}")
  if not File.exists?(langpath)
    langcode = 'en'
    langpath = File.join(plugdir,@@extdir,langdir,"pdScript_menu.#{langcode}")
  end
  @@lang = parse_langfile(langpath) # create the language hash
  @@extension = SketchupExtension.new( @@lang["pdScript interpreter"], "pdScript/pdScript.rb")
  @@extension.description = @@lang["Adds pdScript interpreter to the ruby environment!"]
  @@extension.name = "pdScript interpreter"
  @@extension.creator = "HPW/Precision"
  @@extension.copyright = "2012-01-22"
  @@extension.version = "1.01"

  Sketchup.register_extension( @@extension, false )

end
