require 'sketchup.rb'
module PdScript
  if not file_loaded?(File.basename(__FILE__))
    # UI.messagebox("pdScript loader startet")
    win32api_file = Sketchup.find_support_file "Plugins/Win32API.so", ""
    pdScriptapi_file = Sketchup.find_support_file "Plugins/pdScript/pdScriptE.dll", ""
    # UI.messagebox("pdScriptDll="+pdScriptapi_file)
    if (win32api_file)
      require 'Win32API'
      # UI.messagebox("Win32API loaded ")
      if File.exist? pdScriptapi_file
        @pdScript = Win32API.new(pdScriptapi_file, "pdScriptA", ['P','P','L'], 'I')
        @pdsFreeScript = Win32API.new(pdScriptapi_file, "pdsFreeScript", ['I'], 'I')
        @pdsExecuteFunction = Win32API.new(pdScriptapi_file, "pdsExecuteFunctionA", ['I','P','P','P'], 'I')
        @pdScriptScriptHandle = 0
        # puts "psScript_Result: "
        # puts @pdScript
        dll_file = Sketchup.find_support_file "Plugins/pdScript/RubyConnect.dll", ""
        if (dll_file)
          @FindConnectedWindow = Win32API.new(dll_file, "FindConnectedWindow", ['P','P'], 'P')
  #        UI.messagebox("FindConnectedWindow loaded")
           FindConnectedWindowSU = @FindConnectedWindow.Call("- SketchUp","")
  #        UI.messagebox("Return from FindConnectedWindow: "+FindConnectedWindowSU)
  #      else
  #        UI.messagebox("File RubyConnect.dll is missing in the pdScript-Plugins! pdScript loading fails!")
        end	# if
        # UI.messagebox("pdScript loaded")
        add_separator_to_menu("Plugins")
        pdScript_menu = UI.menu("Plugins").add_submenu(@@lang["pdScript"])
        pdScript_menu.add_item(@@lang["Start pdScript clock Dialog"]) { PdScript.start_clock_dialog }
        pdScript_menu.add_item(@@lang["Start pdScript MyDialog Dialog modal"]) { PdScript.start_mydialog_dialog }
        pdScript_menu.add_item(@@lang["Start pdScript MyDialog Dialog non-modal"]) { PdScript.start_mydialog_nonmodal_dialog }
        pdScript_menu.add_item(@@lang["Start pdScript FreeScript"]) { PdScript.start_freescript }
      else
        UI.messagebox("Cannot find file pdScriptE.dll!")
      end		# if
    else
        UI.messagebox("File Win32API.so is missing in the SketchUp-Plugins-Directory! pdScript loading fails!")
    end	# if
  else
   puts "File "+File.basename(__FILE__)+" was yet loaded!"
  end	# if


  def PdScript.start_clock_dialog
    # UI.messagebox("Before clock Dialog")
    pdScriptclock_file = Sketchup.find_support_file "Plugins/pdScript/Clock.dpas", ""
    retval = @pdScript.Call(pdScriptclock_file,"",0)
    UI.messagebox("Return from Clock-Dialog: "+retval.to_s())
  end

  def PdScript.start_mydialog_dialog
    # UI.messagebox("Before clock Dialog")
    pdScriptMyDialog_file = Sketchup.find_support_file "Plugins/pdScript/MyDialog.dpas", ""
    retval = @pdScript.Call(pdScriptMyDialog_file,"/pds{hide-from-taskbar=true}",0)
    UI.messagebox("Return from Modal-Dialog: "+retval.to_s())
  end

  def PdScript.start_mydialog_nonmodal_dialog
    # UI.messagebox("Before clock Dialog")
    pdScriptMyDialog_file = Sketchup.find_support_file "Plugins/pdScript/MyDialogNon.dpas", ""
    @pdScriptScriptHandle = @pdScript.Call(pdScriptMyDialog_file,"/pds{hide-from-taskbar=true;keep-alive=true;host-app="+FindConnectedWindowSU+"}",0)
    # UI.messagebox("Return from NonModal-Dialog: "+@pdScriptScriptHandle.to_s())
  end

  def PdScript.start_freescript
    # UI.messagebox("Before clock Dialog")
    if @pdScriptScriptHandle > 0
     retval = @pdsFreeScript.Call(@pdScriptScriptHandle)
     @pdScriptScriptHandle = 0
    end
  #  UI.messagebox("Return from Freescript: "+retval.to_s())
  end

  def PdScript.ExecuteFunction(param1, param2, param3)
     # UI.messagebox("Before ExecuteFunction")
     retval = @pdsExecuteFunction.Call(@pdScriptScriptHandle, param1, param2, param3)
     UI.messagebox("Return from ExecuteFunction: "+retval.to_s())
  end

  file_loaded(File.basename(__FILE__))
  
  # Sample calls from RubyConsole to comunicate to open pdScriptdialog
  # PdScript.ExecuteFunction("ChangeEdit2","Value 2 from RubyCall","|")
  # PdScript.ExecuteFunction("ChangeEdit4","Value 4 from RubyCall","|")
  # PdScript.ExecuteFunction("ChangeEdits","Value 1 from RubyCall|Value 2 from RubyCall|Value 3 from RubyCall|Value 4 from RubyCall","|")
end
