# Copyright 2005-2008, Google, Inc.
#   code from "Tools/LangHandler.rb"
#   Modified for use with PdScript module. 2012-JAN
#   renamed to: 'pdScript/langLoad.rb'
#
# -----------------------------------------------------------------------------
#
# Permission to use, copy, modify, and distribute this software for 
# any purpose and without fee is hereby granted, provided that the above
# copyright notice appear in all copies.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# -----------------------------------------------------------------------------

module PdScript

  class << self  # Proxy class bound to THIS module:

    @hash = ""

    #  parse_langfile( langpath )
    #
    #  Args:
    #
    #    langpath  :  a fullpath to a UTF8 encoded strings format file.
    #
    #  Returns a hash object loaded with the new strings, and english keys.
    #
    def parse_langfile(langpath)

      @hash = Hash.new {|hash,key| key }
      # for [] method, returns the arg if key does not exist in hash 

      langFile = File.open(langpath, "r") { |file|

        entryString = ""
        inComment = false

        file.each do |line|
          #ignore simple comment lines - BIG assumption the whole line is a comment
          if !line.include?("//")
            #also ignore comment blocks
            if line.include?("/*")
              inComment = true
            end

            if inComment==true
              if line.include?("*/")
                inComment=false
              end
            else
              entryString += line
            end
          end

          if entryString.include?(";")
            #parse the string into key and value
            
            #remove the white space
            entryString.strip!

            #pull out the key
            keyvalue = entryString.split("\"=\"")
            
            #strip the leading quotation out
            key = keyvalue[0][(keyvalue[0].index("\"")+1)..(keyvalue[0].length+1)]

            #pull out the value
            keyvalue[1].gsub!(";", "")
            value = keyvalue[1].gsub("\"", "") 
#            UI.messagebox("Key: "+key+"    Value: "+value )

            #add to @strings
            @hash[key]=value.chomp

            entryString = ""
          end
        end # do each line
      
      } # end of File.open (File is closed automatically.)

      return @hash

    end # def
  
  end # proxy class

end # module
