;
; ------------------------------------------------------------
;
;   PureBasic - DLL example file
;
;    (c) 2002 - Fantaisie Software
;
; ------------------------------------------------------------
;
; This example is a skeleton to build easely a DLL using PureBasic
; The dll is created in the 'Compilers' directory, under the
; 'purebasic.dll' name. An associated '.lib' is generated to use
; with LccWin32 or VisualC++.
;
;
; Rules to follow:
;   - Never write code outside a procedure, except for variables
;   or structure declaration.
;   
;   - DirectX Init routines must not be initialized in the the
;   AttachProcess() procedure
;   
;   - There is 4 procedures automatically called: AttachProcess(),
;   DetachProcess(), AttachThread() and DetachThread(). If you don't
;   need them, just remove them.
;


  ; This procedure is called once, when the program loads the library
  ; for the first time. All init stuffs can be done here (but not DirectX init)
  ;
  ProcedureDLL AttachProcess(Instance)
  EndProcedure


  ; Called when the program release (free) the DLL
  ;
  ProcedureDLL DetachProcess(Instance)
  EndProcedure


  ; Both are called when a thread in a program call or release (free) the DLL
  ;
  ProcedureDLL AttachThread(Instance)
  EndProcedure

  ProcedureDLL DetachThread(Instance)
  EndProcedure


  ; Real code start here..
  ;
  
  ProcedureDLL NeoFunc1(Message$)
    MessageRequester("EasyRequester !", Message$, #MB_ICONINFORMATION)
  EndProcedure

  ProcedureDLL NeoFunc2(String1.s)
  Global Back.s
  Back.s = String1.s + " Purebasic Returnstring"  
  ProcedureReturn @Back.s
  EndProcedure
 
; ExecutableFormat=Shared Dll
; Executable=C:\Programme\NeoBook\PlugIns\hpwDllCall\puredemo.dll.exe
; EOF